define(['angular', 'MovePrimaryCareToTop'], function(angular){
	'use strict';
	describe('Move Primary Care filter', function(){
		var $filter;
		var a;
		var b;
		var c;
		var d;

		a = [{
			'typeOfCare': 'Audiology',
			'id': '17'
		},{
			'typeOfCare': 'Primary Care',
			'id': '323'
		},{
			'typeOfCare': 'Optometry',
			'id': '3'
		},{
			'typeOfCare': 'Outpatient Mental Health',
			'id': '4'
		}];

		b = [{
			'typeOfCare': 'Dermatology',
			'id': '5'
		},{
			'typeOfCare': 'Gynecology',
			'id': '6'
		},{
			'typeOfCare': 'Physical Therapy',
			'id': '7'
		},{
			'typeOfCare': 'Primary Care',
			'id': '323'
		}];

		c = [{
			'typeOfCare': 'Primary Care',
			'id': '323'
		},{
			'typeOfCare': 'Audiology',
			'id': '10'
		},{
			'typeOfCare': 'Dermatology',
			'id': '11'
		}];

		d = [{
			'typeOfCare': 'Gynecology',
			'id': '12'
		},{
			'typeOfCare': 'Optometry',
			'id': '13'
		},{
			'typeOfCare': 'Primary Care',
			'id': '323'
		},{
			'typeOfCare': 'Outpatient Mental Health',
			'id': '15'
		},{
			'typeOfCare': 'Physical Therapy',
			'id': '16'
		}];

		beforeEach(function() {
			module('angularTemplateApp');
			inject(function (_$filter_) {
				$filter = _$filter_;
			});
		});

		it('should move item with id 323 to the top of the list', function() {
			expect(a[0].id).toBe('17');
			a = $filter('movePrimaryCareToTop')(a);
			expect(a[0].id).toBe('323');

			expect(b[0].id).toBe('5');
			b = $filter('movePrimaryCareToTop')(b);
			expect(b[0].id).toBe('323');

			expect(c[0].id).toBe('323');
			c = $filter('movePrimaryCareToTop')(c);
			expect(c[0].id).toBe('323');

			expect(d[0].id).toBe('12');
			d = $filter('movePrimaryCareToTop')(d);
			expect(d[0].id).toBe('323');
		});
	});
});